<?php
//            dbmailer.php version 1.1 Feb 24, 2000
//            Norman Clarke <norman@dontblink.com>  
//
// dbmailer.php is copyright 2000 Norman Clarke, and
// is released under the terms of the GNU General
// Public License. Please see the file "COPYING" that
// should have come with this program, or visit
// http://www.gnu.org for details. 

// ***********************CONFIG SECTION***********************
// To get the program working correctly, you will need to make some 
// modifications here. Also, please read the README file for
// more details if you need them.

// This gets displayed when people submit the form without errors.
// If you want to include a whole file instead of just a message,
// comment it out and uncomment and alter the next variable

$confirmation = 'Your message has been sent successfully!';

// Uncomment and specify this if instead of a simple message,
// you want a whole HTML or PHP file shown to the user after
// they successfully submit the form.

#$confirmation_file = 'absoulte/path/to/my/file/success.html';

// If you instead want to rdirect the visitor to a specific URL
// once their page is successfully sent, uncomment and alter the
// variable below. Can be an absolute or relative URL.

#$redirect = 'http://www.yahoo.com';

// This is where you want email sent to if you are emailing
// the results rather than saving them to a file. As of version
// 1.1 it *must* be specified here and not in a hidden form field
// for security reasons.

$mailto = "user@host";

// This is where your form submissions will be saved if you are
// saving the results to a delimited file rather than emailing them
// somewhere. It can not be specified as a hidden form value
// because this is a security risk.

$filename="/tmp/moveme.tab";

// This is the character used as the delimiter in delimited files.
// "\t" is a tab character. Other ideas might be comma or pipe ("|").
// By default, all entries in the delimited files a enclosed by double
// quotes, and odd characters (like double quotes) are escaped by a 
// backslash. If you don't know what this means, don't worry. You'll
// easily figure it out when you need to and will be fine if the 
// occaison does not arise.

$delim = "\t";

// Make "keep_blanks" TRUE to keep blank form fields in your emails.
// Make it FALSE to ignore blank form fields.
// Delimited files automatically keep the blank values in order to 
// remain consistent.

$keep_blanks = TRUE; 

// ***********************END CONFIG SECTION********************
// don't alter anything below unless you know what you're doing.

function confirm_sent() {
	global $redirect;
	global $confirmation;
	global $confirmation_file;

	if ($redirect) {
		header("Location: $redirect");
	}
	
	if ($confirmation) {
		echo "$confirmation";
		exit();
	}
	elseif ($confirmation_file) {
		include "$confirmation_file";
		exit();
	}
	else { // The default confirmation, just in case.
		echo "Thank you. Your message was sent successfully!";
	}
}

# check for a few simple errors

// If someone tries to use the file functionality to overwrite pages on 
// your site it won't succeed.

if ($HTTP_POST_VARS[filename]) { 
	die("The filename variable can not be declared in a hidden form
	field as of version 1.1. Please specify it in the script
	file itself as this is a potential security hole.");
}

// If someone tries to use your form to spam people anonymously
// it won't succeed.

if ($HTTP_POST_VARS[mailto]) { 
	die("The mailto variable can not be declared in a hidden form
	field as of version 1.1. Please specify it in the script
	file itself as this is a potential security hole.");
}

// GET vars don't work, only POST.
if (!$HTTP_POST_VARS || $HTTP_GET_VARS) {
die("No vars were *posted* to the form. Check your form design and make sure
you set the \"method\" attribute on the form tag to \"post\"; i.e; 
&lt;form action=\"dbmailer.php\" method=\"post\"&gt;. You should not see
any form garbage in the URL if everything is set up right.");
}

if (!$action) {
	$action = 'mail';
}

if ($action == 'mail' && !$from) {
	$from = 'www';
}

if ($action == 'mail' && !$mailto) {
	die ("No mailto is specified! If you want the form to email the results, then
	you must specify a mailto variable so that they get sent somewhere.");
}
if ($action == 'file' && !$filename) {
	die ("No filename is specified! If you want the form results saved to a file,
	you must specify where you want them saved. A valid filename would look
	like \"/my/file/path/filename.tab\"");
}

# the main loop, assuming all errors got trapped above.

if ($action == 'mail') {
	while(list($key, $val) = each($HTTP_POST_VARS)) { 
	    if ($keep_blanks) {
            $message .= "$key: $val\n";
	    }
	    else {
	       if($val) {
	       $message .= "$key: $val\n";
	       }
	    }
	}
	mail("$mailto", "$subject", "$message","From: $from");
	confirm_sent();
}
elseif ($action == 'file') {
	
$i = 0;
while(list($key, $val) = each($HTTP_POST_VARS)) { 
	$num_fields = count($HTTP_POST_VARS);
	$message .= "\"$val\"";
	if ($i < ($num_fields - 1)) {
	    $message .= $delim;
	}
	$i++;
	}
	$message .= "\n";
	$fp = fopen("$filename","a");
	fwrite($fp,$message);
	confirm_sent();
   }
?>
